/**********************************************************
 *(c) by Knobloch GmbH
 *       Weedgasse 14 
 *       D-55234 Erbes-Bdesheim                                    
 *
 *  File:           ftdemo1.c       Sampleprogram for Robo-Interface C-Compiler
 *                                  and RF-Data-Link to transmit Messages
 *
 *  Version:        0.01
 *
 *  Revision:
 *          0.01:   15.01.2006
 *                  Start
 *
 *  This Sample looks at input I1. If it is "1" a message is transmit
 *  over RF with the "Send and Get Back" function (so you can test it with
 *  only one Interface and one RF-Data-Link Set). 
 *
 *	Every Message is also transmit over the serial Port. With a "X"-Cable 
 *	you can receive and transmit serial messages between two Interfaces.
 *
 *  If the program gets in the background a message, the procedure
 *  WriteMessageToBuffer() writes the received Message in the internal buffer.
 *  The GetMessageFromBuffer() function reads the message and writes Messagebyte 0
 *  to the outputs.
 *
 *  The program stops, if Input I8 ist set to "1".
 *
 *  Then it jumps with a "return(x)" back to the Robo-If firmware.
 *  The firmware checks the value of "x" and the red "Error-Led"
 *  counts the x-value. With "0", the LED isnt blinking.
 *  You can use this function for testing your program.
 **********************************************************/
                  
#include    "TA_Firmware\TAF_00D.h"              // Definitions of Datastructures and Firmware Constants
#include    "TA_Firmware\TAF_00P.h"              // Definitions of Firmware Prototypes
#include    "Message\Msg_00D.h"
#include    "Message\Msg_00P.h"



UCHAR main(void)
{
    UINT        uiParameter,
                uiCountMsg;
    UCHAR       ucParameter,
                ucLastInp,
                ucInp,
                ucX,
                ucStatus;

    UCHAR       ucRfSetting[4];
    SMESSAGE    sMessage;


	InitMessage();
    SetFtMessageReceiveAddress( (void far*) &WriteMessageToBuffer );
    SetFtDeviceCommMode(IF_COM_MESSAGE, 0, &uiParameter);   	// SER-Port = Messagemode
																// Now the COM - Led is lightning
																
    // New PWM for Outputs
    sTrans.MPWM_Main[0] = 8;    // PWM for Output O1
    sTrans.MPWM_Main[1] = 8;    // PWM for Output O2
    sTrans.MPWM_Main[2] = 8;    // PWM for Output O3
    sTrans.MPWM_Main[3] = 8;    // PWM for Output O4
    sTrans.MPWM_Main[4] = 8;    // PWM for Output O5
    sTrans.MPWM_Main[5] = 8;    // PWM for Output O6
    sTrans.MPWM_Main[6] = 8;    // PWM for Output O7
    sTrans.MPWM_Main[7] = 8;    // PWM for Output O8

    // New Value for Outputs
    // Output PWM update (0x01=always, 0x02=once)
    // Base+0xE1: | 0  | 0  | 0  | 0  | 0  | 0  |ONCE|ALWA|
    sTrans.MPWM_Update = 0x01;  // Update PWM values every 10ms (always)

    ucLastInp = sTrans.E_Main;
    ucInp = ucLastInp;
    uiCountMsg = 0;


    // I1: 1 = Send one Message
    // I8: 1 = Exit Loop / Program
    do
    {
        ucStatus = GetMessageFromBuffer(&sMessage);
        switch (ucStatus)
        {
            case ERROR_SUCCESS:
				// for debugging
				sTrans.ucDbg1F0++;						// Debugcounter at 0x5F0 at memory (for testing)
														// You can read this with FtLoader.exe

    			sTrans.M_Main = sMessage.B.ucB0;      	// switch Outputs
				break;

            default:
                break;
        }

        ucInp = sTrans.E_Main;
        if ( (ucLastInp & 0x01) != (ucInp & 0x01) )     // I1 = Message senden
        {
            if (ucInp & 0x01)
            {
				// for debugging
				sTrans.ucDbg1F1++;						// Debugcounter at 0x5F1 at memory (for testing)
														// You can read this with FtLoader.exe

				uiCountMsg++;
                sMessage.B.ucB0 = (UCHAR) uiCountMsg;

                ucParameter = SendFtMessage(MSG_HWID_SER, 0, sMessage.L.ulMsg, 50, MSG_SEND_IF_NOT_PRESENT);
                ucParameter = SendFtMessage(MSG_HWID_RF_SELF, 0, sMessage.L.ulMsg, 50, MSG_SEND_IF_NOT_PRESENT);
			}
        }

        ucLastInp = ucInp;
    }
    while ( (sTrans.E_Main & 0x80) == 0);               // I8 = Ende
    sTrans.M_Main = 0;                                  // switch Outputs OFF

    SetFtDeviceCommMode(IF_COM_ONLINE, 0, &uiParameter);   		// SER-Port = Onlinemode



    return (0);     // number of "Error - LED" blink times (0..5) after 
                    // program is finished
                    // With >5, the ERROR Led starts continously blinking. 
                    // You can stop this with pressing the Interface PROG Switch.
}


// End of File
